# İLK SUPER ADMİN OLUŞTURMA REHBERİ

Bu dosya, yeni bir Supabase veritabanı kurulumundan sonra ilk super admin kullanıcısını nasıl oluşturacağınızı açıklar.

## ADIM 1: Supabase Veritabanınızı Kurduysanız

Eğer `MUSTERI-TAM-KURULUM.sql` dosyasını çalıştırdıysanız, veritabanı tabloları hazır demektir.

## ADIM 2: İlk Kullanıcıyı Kayıt Et

1. Web sitenize gidin
2. "Giriş Yap" > "Kayıt Ol" tıklayın
3. Email ve şifrenizle kayıt olun
4. Email doğrulaması yapın (Supabase email ayarlarınız varsa)

## ADIM 3: Kullanıcıyı Super Admin Yap

### Yöntem 1: Supabase Dashboard'dan (ÖNERİLEN)

1. Supabase Dashboard'a gidin: https://supabase.com/dashboard
2. Projenizi seçin
3. Sol menüden **"Table Editor"** seçin
4. **"profiles"** tablosunu açın
5. Az önce kaydolduğunuz kullanıcıyı bulun
6. O satırın **"role"** kolonunu bulun ve **"super_admin"** yazın
7. Değişiklikleri kaydedin

### Yöntem 2: SQL Query ile

1. Supabase Dashboard > **"SQL Editor"** seçin
2. Aşağıdaki komutu çalıştırın (EMAIL'i kendi email adresinizle değiştirin):

```sql
-- Kendi email adresinizi buraya yazın
UPDATE profiles
SET role = 'super_admin'
WHERE email = 'sizin@email.com';
```

3. **"Run"** butonuna tıklayın

## ADIM 4: Kontrol Edin

1. Web sitenizde çıkış yapın
2. Tekrar giriş yapın
3. Artık admin paneline erişebilmelisiniz!

## ADIM 5: Admin Panelinden Diğer Adminleri Ekleyin

Artık super admin olduğunuza göre:

1. Admin Paneli > **"Yönetici Kullanıcılar"** seçin
2. **"Yönetici Ekle"** butonuna tıklayın
3. Diğer adminleri buradan ekleyebilirsiniz

## ⚠️ ÖNEMLİ NOTLAR

- İlk super admin'i mutlaka güvenli bir email/şifre ile oluşturun
- Şifrenizi kimseyle paylaşmayın
- En az 2 super admin oluşturmanızı öneririz (yedek için)
- Admin paneline erişim için güçlü şifre kullanın (min 12 karakter)

## 🆘 Sorun mu Yaşıyorsunuz?

### "profiles" tablosu bulunamıyor hatası:
- `MUSTERI-TAM-KURULUM.sql` dosyasını çalıştırmadıysanız çalıştırın
- Veya `FULL_DATABASE_SETUP.sql` dosyasını kullanın

### Email doğrulaması gelmiyor:
- Supabase > Authentication > Email Templates > "Confirm signup" kontrol edin
- SMTP ayarlarınızı kontrol edin
- Test için email doğrulamasını geçici olarak kapatabilirsiniz:
  - Supabase > Authentication > Providers > Email > "Enable email confirmation" kapatın

### Admin paneline erişemiyorum:
- Önce çıkış yapıp tekrar giriş yapın
- Browser cache'i temizleyin (Ctrl+Shift+Delete)
- Incognito/Private modda deneyin
- Console'da hata var mı kontrol edin (F12)

## 📞 Destek

Sorun devam ederse bizimle iletişime geçin.
