# 📧 MÜŞTERİ E-POSTA SİSTEMİ KURULUM REHBERİ

> **Hedef:** Müşterilerinizin "Şifremi Unuttum" ve kayıt e-postalarında sorun yaşamaması için 5 dakikada kurulum

---

## ⚡ HIZLI KURULUM (5 DAKİKA)

### ADIM 1: Supabase Dashboard'a Giriş

1. 🌐 [https://supabase.com](https://supabase.com) adresine gidin
2. 🔑 Projenizi seçin
3. 📂 Sol menüden **Authentication** → **Email Templates** tıklayın

---

### ADIM 2: Kayıt Onay E-postası (Confirm Signup)

**1. "Confirm signup" sekmesini seçin**

**2. Tüm içeriği silin ve aşağıdaki template'i yapıştırın:**

```html
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Adresinizi Onaylayın</title>
</head>
<body style="margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif; background-color: #f3f4f6;">
    <div style="max-width: 600px; margin: 0 auto; background: #ffffff;">
        <!-- Header -->
        <div style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 40px 30px; text-align: center;">
            <div style="font-size: 32px; font-weight: 800; color: #ffffff; letter-spacing: -0.5px;">
                📜 Script Satış Dünyası
            </div>
            <div style="color: #d1fae5; font-size: 14px; margin-top: 8px;">
                Profesyonel Web Çözümleri
            </div>
        </div>

        <!-- Content -->
        <div style="padding: 40px 30px;">
            <h2 style="color: #1f2937; margin: 0 0 16px 0; font-size: 24px;">
                🎉 Hoş Geldiniz!
            </h2>

            <p style="color: #4b5563; font-size: 15px; line-height: 1.7; margin: 0 0 24px 0;">
                Merhaba,
            </p>

            <p style="color: #4b5563; font-size: 15px; line-height: 1.7; margin: 0 0 24px 0;">
                <strong>Script Satış Dünyası</strong> platformumuza kayıt olduğunuz için çok teşekkür ederiz! Hesabınızı aktifleştirmek için lütfen aşağıdaki butona tıklayın.
            </p>

            <!-- CTA Button -->
            <div style="text-align: center; margin: 32px 0;">
                <a href="{{ .ConfirmationURL }}"
                   style="display: inline-block; background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 16px 40px; text-decoration: none; border-radius: 10px; font-weight: 600; font-size: 15px; box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);">
                    ✅ Email Adresimi Onayla
                </a>
            </div>

            <!-- Info Box -->
            <div style="background: #f0fdf4; border-left: 4px solid #10b981; padding: 20px; border-radius: 8px; margin: 24px 0;">
                <div style="font-weight: 700; color: #047857; margin-bottom: 8px; font-size: 15px;">
                    📌 Önemli Bilgi
                </div>
                <div style="color: #047857; font-size: 14px; line-height: 1.6;">
                    Bu işlemi siz yapmadıysanız, bu e-postayı güvenle görmezden gelebilirsiniz. Hesabınız oluşturulmayacaktır.
                </div>
            </div>

            <p style="color: #6b7280; font-size: 14px; line-height: 1.6; margin: 24px 0 0 0;">
                Buton çalışmıyorsa, aşağıdaki URL'i tarayıcınıza kopyalayın:
            </p>
            <p style="color: #10b981; font-size: 13px; word-break: break-all; margin: 8px 0;">
                {{ .ConfirmationURL }}
            </p>

            <!-- Features -->
            <div style="background: #f9fafb; padding: 24px; border-radius: 12px; margin: 32px 0;">
                <div style="font-weight: 700; color: #1f2937; margin-bottom: 16px; font-size: 16px; text-align: center;">
                    ✨ Neler Yapabilirsiniz?
                </div>
                <div style="color: #4b5563; font-size: 14px; line-height: 2;">
                    ✅ Premium scriptleri satın alın<br>
                    ✅ Lisanslarınızı yönetin<br>
                    ✅ Bayilik avantajlarından faydalanın<br>
                    ✅ 7/24 teknik destek alın
                </div>
            </div>

            <!-- Contact -->
            <div style="background: #eff6ff; padding: 20px; border-radius: 12px; margin: 32px 0;">
                <div style="font-weight: 700; color: #1f2937; margin-bottom: 12px; font-size: 15px;">
                    📞 Yardıma mı ihtiyacınız var?
                </div>
                <div style="color: #4b5563; font-size: 14px; line-height: 1.8;">
                    📧 info@scriptsatisdunyasi.com<br>
                    📱 +90 (552) 065 71 21<br>
                    ⏰ 7/24 Müşteri Desteği
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div style="background: #1f2937; color: #9ca3af; text-align: center; padding: 32px 30px; font-size: 13px;">
            <div style="color: #ffffff; font-weight: 700; font-size: 16px; margin-bottom: 8px;">
                Script Satış Dünyası
            </div>
            <div style="margin: 8px 0; line-height: 1.6;">
                Profesyonel web scriptleri ve yazılım çözümleri<br>
                © 2025 Tüm hakları saklıdır.
            </div>
        </div>
    </div>
</body>
</html>
```

**3. "Save" butonuna basın ✅**

---

### ADIM 3: Şifre Sıfırlama E-postası (Reset Password)

**1. "Reset Password" sekmesini seçin**

**2. Tüm içeriği silin ve aşağıdaki template'i yapıştırın:**

```html
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Şifre Sıfırlama</title>
</head>
<body style="margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif; background-color: #f3f4f6;">
    <div style="max-width: 600px; margin: 0 auto; background: #ffffff;">
        <!-- Header -->
        <div style="background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%); padding: 40px 30px; text-align: center;">
            <div style="font-size: 32px; font-weight: 800; color: #ffffff; letter-spacing: -0.5px;">
                📜 Script Satış Dünyası
            </div>
            <div style="color: #93c5fd; font-size: 14px; margin-top: 8px;">
                Profesyonel Web Çözümleri
            </div>
        </div>

        <!-- Content -->
        <div style="padding: 40px 30px;">
            <h2 style="color: #1f2937; margin: 0 0 16px 0; font-size: 24px;">
                🔐 Şifre Sıfırlama Talebi
            </h2>

            <p style="color: #4b5563; font-size: 15px; line-height: 1.7; margin: 0 0 24px 0;">
                Merhaba,
            </p>

            <p style="color: #4b5563; font-size: 15px; line-height: 1.7; margin: 0 0 24px 0;">
                Hesabınız için şifre sıfırlama talebinde bulundunuz. Yeni bir şifre oluşturmak için aşağıdaki butona tıklayın:
            </p>

            <!-- CTA Button -->
            <div style="text-align: center; margin: 32px 0;">
                <a href="{{ .ConfirmationURL }}"
                   style="display: inline-block; background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%); color: white; padding: 16px 40px; text-decoration: none; border-radius: 10px; font-weight: 600; font-size: 15px; box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);">
                    🔑 Şifremi Sıfırla
                </a>
            </div>

            <!-- Warning Box -->
            <div style="background: #fef2f2; border-left: 4px solid #dc2626; padding: 20px; border-radius: 8px; margin: 24px 0;">
                <div style="font-weight: 700; color: #991b1b; margin-bottom: 8px; font-size: 15px;">
                    ⚠️ Güvenlik Uyarısı
                </div>
                <div style="color: #991b1b; font-size: 14px; line-height: 1.6;">
                    • Bu link <strong>1 saat</strong> boyunca geçerlidir<br>
                    • Bu işlemi siz yapmadıysanız, hemen bizimle iletişime geçin<br>
                    • Şifrenizi kimseyle paylaşmayın
                </div>
            </div>

            <p style="color: #6b7280; font-size: 14px; line-height: 1.6; margin: 24px 0 0 0;">
                Link çalışmıyorsa, aşağıdaki URL'i tarayıcınıza kopyalayın:
            </p>
            <p style="color: #2563eb; font-size: 13px; word-break: break-all; margin: 8px 0;">
                {{ .ConfirmationURL }}
            </p>

            <!-- Contact -->
            <div style="background: #f9fafb; padding: 20px; border-radius: 12px; margin: 32px 0;">
                <div style="font-weight: 700; color: #1f2937; margin-bottom: 12px; font-size: 15px;">
                    📞 Yardıma mı ihtiyacınız var?
                </div>
                <div style="color: #4b5563; font-size: 14px; line-height: 1.8;">
                    📧 info@scriptsatisdunyasi.com<br>
                    📱 +90 (552) 065 71 21<br>
                    ⏰ 7/24 Müşteri Desteği
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div style="background: #1f2937; color: #9ca3af; text-align: center; padding: 32px 30px; font-size: 13px;">
            <div style="color: #ffffff; font-weight: 700; font-size: 16px; margin-bottom: 8px;">
                Script Satış Dünyası
            </div>
            <div style="margin: 8px 0; line-height: 1.6;">
                Profesyonel web scriptleri ve yazılım çözümleri<br>
                © 2025 Tüm hakları saklıdır.
            </div>
        </div>
    </div>
</body>
</html>
```

**3. "Save" butonuna basın ✅**

---

### ADIM 4: Magic Link'i Devre Dışı Bırakın (ÖNEMLİ!)

**1. Sol menüden:** **Authentication** → **Providers**

**2. "Email" provider'ını bulun ve tıklayın**

**3. Ayarları şu şekilde yapın:**

```
✅ Enable Email Provider: AÇIK
✅ Confirm Email: AÇIK
❌ Secure email change: AÇIK (opsiyonel)
❌ Enable Magic Link: KAPALI ⚠️ (ÇOK ÖNEMLİ!)
```

**4. "Save" butonuna basın ✅**

---

### ADIM 5: URL Ayarları (KRİTİK!)

**1. Sol menüden:** **Authentication** → **URL Configuration**

**2. Ayarları müşterinizin domain'i ile yapın:**

#### Canlı Site İçin:
```
Site URL: https://musteri-domain.com

Redirect URLs (her satır ayrı):
https://musteri-domain.com/**
https://musteri-domain.com/auth/reset-password
https://musteri-domain.com/auth/callback
```

#### Test + Canlı (İkisi Birden):
```
Site URL: https://musteri-domain.com

Redirect URLs (her satır ayrı):
https://musteri-domain.com/**
https://musteri-domain.com/auth/reset-password
https://musteri-domain.com/auth/callback
http://localhost:5173/**
http://localhost:5173/auth/reset-password
```

**⚠️ ÖNEMLİ:** Site URL'i hangi domain ise, e-postalardaki linkler oraya gider!

**3. "Save" butonuna basın ✅**

---

## 🧪 TEST ETME

### Test 1: Kayıt E-postası
1. Yeni bir test kullanıcısı oluşturun
2. E-posta kutusunu kontrol edin
3. ✅ "Email Adresimi Onayla" butonu görmeli
4. ✅ Linke tıklayınca doğru domain'e gitmeli
5. ❌ "Magic link to login" yazmamalı

### Test 2: Şifre Sıfırlama
1. "Şifremi Unuttum"a tıklayın
2. E-posta kutusunu kontrol edin
3. ✅ "Şifremi Sıfırla" butonu görmeli
4. ✅ 1 saat geçerli olduğu yazmalı
5. ✅ Link çalışmalı

---

## 🔥 SIFIR HATA KONTROL LİSTESİ

**Kurulumdan önce:**
```
☐ Supabase projesine erişim var mı?
☐ Müşterinin domain'i belli mi?
☐ Test e-posta adresi hazır mı?
```

**Kurulumdan sonra:**
```
☐ Confirm Signup template'i kaydedildi mi?
☐ Reset Password template'i kaydedildi mi?
☐ Magic Link KAPALI mı?
☐ Confirm Email AÇIK mı?
☐ Site URL doğru domain'e ayarlı mı?
☐ Redirect URLs eklendi mi?
☐ Test e-postası gönderildi mi?
☐ Test e-postası alındı mı?
☐ Link çalışıyor mu?
```

---

## 🎯 SIFIR SORUN GARANTİSİ

**Eğer e-posta gelmiyorsa:**

1. ✅ Supabase → Settings → Project Settings → API → Email rate limits kontrolü
2. ✅ Spam klasörünü kontrol edin
3. ✅ Supabase → Authentication → Users → kullanıcıyı manuel onaylayın (geçici)
4. ✅ Template'lerde `{{ .ConfirmationURL }}` yazdığından emin olun (başında/sonunda boşluk olmamalı)

**Eğer link localhost'a gidiyorsa:**

1. ✅ Site URL'i production domain olmalı
2. ✅ Ayarları kaydettikten sonra 5 dakika bekleyin (cache)
3. ✅ Yeni bir test e-postası gönderin

**Eğer "Magic Link" diyorsa:**

1. ✅ Magic Link KAPALI mı kontrol edin
2. ✅ Template'i kaydettiğinizden emin olun
3. ✅ Yeni bir test e-postası gönderin

---

## 💡 EKSTRA İPUÇLARI

### İletişim Bilgilerini Güncelleyin

Template'lerdeki bu bölümü müşterinizin bilgileri ile değiştirin:

```html
📧 info@scriptsatisdunyasi.com
📱 +90 (552) 065 71 21
```

### Footer'ı Güncelleyin

```html
© 2025 Tüm hakları saklıdır.
```

### Site Adını Değiştirin

Template'lerdeki "Script Satış Dünyası" metnini müşterinizin site adı ile değiştirin.

---

## ✅ İŞLEM TAMAMLANDI!

Bu rehberi takip ettiyseniz:

- ✅ Kayıt e-postaları profesyonel tasarımla gidiyor
- ✅ Şifre sıfırlama e-postaları çalışıyor
- ✅ Linkler doğru domain'e gidiyor
- ✅ Müşteriler sorun yaşamıyor

**🎉 Kurulum tamamlandı! Artık e-posta sistemi hazır!**

---

## 📞 DESTEK

Sorun yaşarsanız:
- 📧 info@scriptsatisdunyasi.com
- 📱 +90 (552) 065 71 21
- 💬 7/24 Teknik Destek
