# 🚀 SUPABASE KURULUM - TEK ADIMDA TAMAMLA!

## 📋 ÖNEMLİ: Sadece 3 Adım!

Bu rehber ile veritabanınızı **5 dakikada** kuracaksınız. Hiçbir teknik bilgi gerekmez!

---

## ✅ ADIM 1: Supabase Projenizi Açın

1. 🌐 **Tarayıcınızda şu adresi açın:** https://supabase.com
2. 🔑 **Giriş yapın** (Hesabınız yoksa ücretsiz hesap oluşturun)
3. 📁 **Projenizi seçin** (Sol üstteki proje adına tıklayın)

> 💡 **İPUCU:** Henüz proje oluşturmadıysanız "New Project" butonuna tıklayın ve proje adı verin.

---

## ✅ ADIM 2: SQL Editor'ü Açın

1. 📊 **Sol menüden "SQL Editor" seçeneğine tıklayın**
   - Sol taraftaki menüde yeşil bir veritabanı ikonu göreceksiniz
   - Yanında "SQL Editor" yazısı var

2. ➕ **"New query" butonuna tıklayın**
   - Sağ üstte mavi bir buton
   - Boş bir SQL editör penceresi açılacak

---

## ✅ ADIM 3: SQL Dosyasını Yapıştırıp Çalıştırın

### 📝 3.1 - SQL Dosyasını Açın

1. 📂 **Projenizin klasöründe `supabase` klasörünü bulun**
2. 📄 **`KOLAY_KURULUM.sql` dosyasını herhangi bir metin editörü ile açın**
   - Not Defteri (Windows)
   - TextEdit (Mac)
   - Notepad++
   - VS Code

### 📋 3.2 - İçeriği Kopyalayın

1. ⌨️ **Tüm içeriği seçin:** `Ctrl+A` (Windows) veya `Cmd+A` (Mac)
2. 📄 **Kopyalayın:** `Ctrl+C` (Windows) veya `Cmd+C` (Mac)

### 🎯 3.3 - Supabase'e Yapıştırın

1. 🖱️ **SQL Editor penceresine tıklayın**
2. 📋 **Yapıştırın:** `Ctrl+V` (Windows) veya `Cmd+V` (Mac)
3. ▶️ **SAĞ ALT köşedeki "RUN" butonuna tıklayın**
   - Yeşil bir play (▶️) ikonu göreceksiniz
   - Butona bastıktan sonra 10-30 saniye bekleyin

### ✅ 3.4 - Sonucu Kontrol Edin

**✨ BAŞARILI!** ekranında şu çıktıyı görmelisiniz:

```
✅ Success. No rows returned
```

veya

```
Tablo               | Kayıt Sayısı
--------------------|-------------
Profiles            | 0
Categories          | 6
Products            | 0
Dealer Packages     | 3
Site Settings       | 1
```

---

## 🎉 KURULUM TAMAMLANDI!

### ✅ Kontrol Listesi

- [x] Supabase projesi oluşturuldu
- [x] SQL Editor açıldı
- [x] KOLAY_KURULUM.sql çalıştırıldı
- [x] Tüm tablolar oluşturuldu
- [x] Örnek veriler eklendi

---

## 🔐 ADIM 4: .env Dosyasını Ayarlayın

### 📍 4.1 - Supabase Bilgilerini Bulun

1. **Supabase Dashboard'da sol menüden "Settings" > "API" seçeneğine gidin**

2. **Şu bilgileri kopyalayın:**
   - `Project URL` (örnek: https://xxxxxxxxxxx.supabase.co)
   - `anon public` key (uzun bir kod)

### 📝 4.2 - .env Dosyasını Düzenleyin

1. **Proje klasöründe `.env` dosyasını açın** (kök dizinde)
   > Dosya görünmüyorsa `.env.example` dosyasını kopyalayıp `.env` olarak yeniden adlandırın

2. **Şu satırları bulun ve düzenleyin:**

```env
VITE_SUPABASE_URL=buraya_project_url_yapistirin
VITE_SUPABASE_ANON_KEY=buraya_anon_key_yapistirin
```

**ÖRNEK:**
```env
VITE_SUPABASE_URL=https://abcd1234.supabase.co
VITE_SUPABASE_ANON_KEY=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...
```

3. **Dosyayı kaydedin:** `Ctrl+S` (Windows) veya `Cmd+S` (Mac)

---

## 🎯 ADIM 5: İlk Admin Hesabı Oluşturun

### 🔑 5.1 - Yeni Kullanıcı Kayıt Edin

1. **Uygulamanızı tarayıcıda açın**
2. **"Kayıt Ol" butonuna tıklayın**
3. **Bilgilerinizi girin:**
   - Ad Soyad: İstediğiniz adı yazın
   - E-posta: Gerçek e-posta adresiniz
   - Şifre: Güçlü bir şifre (min. 6 karakter)

4. **"Kayıt Ol" butonuna basın**

### 👑 5.2 - Admin Yetkisi Verin

**KOLAY YÖNTEM - Otomatik SQL:**

1. **Supabase Dashboard > SQL Editor'e geri dönün**
2. **"New query" açın**
3. **Şu SQL kodunu yapıştırın:**

```sql
-- E-posta adresinizi buraya yazın
UPDATE auth.users
SET raw_user_meta_data = raw_user_meta_data || '{"role": "super_admin"}'::jsonb
WHERE email = 'BURAYA_EPOSTA_ADRESINIZI_YAZIN';

-- Profiles tablosunda da güncelleyin
UPDATE profiles
SET role = 'super_admin'
WHERE email = 'BURAYA_EPOSTA_ADRESINIZI_YAZIN';
```

4. **E-posta adresinizi kodda değiştirin** (iki yerde)
5. **"RUN" butonuna basın**
6. **Çıkış yapıp tekrar giriş yapın**

---

## ❌ Olası Hatalar ve Çözümleri

### 🔴 Hata: "relation already exists"

**Çözüm:** Bu tablolar zaten oluşturulmuş demektir. Sorun yok, devam edebilirsiniz!

```sql
-- Eğer temiz baştan başlamak isterseniz (DİKKAT: Tüm veriler silinir!)
DROP SCHEMA public CASCADE;
CREATE SCHEMA public;
-- Sonra KOLAY_KURULUM.sql'i tekrar çalıştırın
```

### 🔴 Hata: "permission denied"

**Çözüm:** SQL Editor'de "RUN" butonunun yanındaki ayarlardan "Auto" yerine "Single query" seçin.

### 🔴 Hata: "syntax error"

**Çözüm:**
- SQL dosyasının tamamını kopyaladığınızdan emin olun
- Dosyayı UTF-8 encoding ile kaydedin
- Farklı bir metin editörü deneyin (Notepad++ önerilir)

### 🔴 Admin paneline giriş yapamıyorum

**Çözüm:**
1. Tarayıcı önbelleğini temizleyin (Ctrl+Shift+Delete)
2. Çıkış yapıp tekrar giriş yapın
3. ADIM 5.2'deki SQL kodunu tekrar çalıştırın
4. E-posta adresinizin doğru olduğundan emin olun

---

## 📞 Destek

Sorun yaşıyorsanız:

1. ✅ **Kontrol listesini tekrar gözden geçirin**
2. 🔍 **Hata mesajını okuyun ve yukarıdaki çözümlere bakın**
3. 📧 **Destek ekibine ulaşın:** info@scriptmarket.com
4. 💬 **Canlı destek butonu** (sağ altta)

---

## 🎓 Ek Kaynaklar

- 📚 [Supabase Resmi Dokümantasyon](https://supabase.com/docs)
- 🎥 [Video Kurulum Rehberi](https://youtube.com)
- 📖 [Detaylı Admin Paneli Kullanımı](./ADMIN-KURULUM-REHBERI.md)

---

## ✨ Tebrikler!

Veritabanınız başarıyla kuruldu ve kullanıma hazır!

🚀 **Sırada ne var?**
1. Admin paneline giriş yapın: `/admin`
2. Site ayarlarını düzenleyin
3. Kategorileri ve ürünleri ekleyin
4. Test siparişi verin

**İyi satışlar! 🎉**
