<?php
/**
 * PayTR Callback Proxy
 * Bu dosya PayTR'den gelen callback'i Supabase Edge Function'a yönlendirir
 *
 * Kullanım:
 * 1. Bu dosyayı hosting'inizin public_html veya www klasörüne yükleyin
 * 2. PayTR panel'de Bildirim URL: https://www.scriptsatisdunyasi.com.tr/paytr-callback.php
 */

header('Content-Type: text/plain');

// Hata raporlamayı aç (geliştirme için)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/paytr-callback-errors.log');

// Log fonksiyonu
function logMessage($message) {
    $timestamp = date('Y-m-d H:i:s');
    $logFile = __DIR__ . '/paytr-callback.log';
    file_put_contents($logFile, "[$timestamp] $message\n", FILE_APPEND);
}

try {
    logMessage("=== PayTR Callback Received ===");

    // POST verilerini al
    $postData = $_POST;

    if (empty($postData)) {
        logMessage("ERROR: No POST data received");
        echo "FAIL";
        exit;
    }

    logMessage("POST Data: " . json_encode($postData));

    // Supabase Edge Function URL
    $supabaseUrl = 'https://mkblxevmofphtdcidnql.supabase.co/functions/v1/paytr-callback';

    logMessage("Forwarding to Supabase: $supabaseUrl");

    // cURL ile Supabase'e POST isteği gönder
    $ch = curl_init($supabaseUrl);

    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($postData),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/x-www-form-urlencoded',
        ],
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);

    curl_close($ch);

    logMessage("Supabase Response Code: $httpCode");
    logMessage("Supabase Response: $response");

    if ($curlError) {
        logMessage("cURL Error: $curlError");
        // Even on error, we should return OK to PayTR to prevent retry loops
        echo "OK";
        exit;
    }

    // PayTR requires "OK" response to confirm receipt of notification
    // We always return OK if request reached Supabase (even if order not found, etc.)
    // This prevents transactions from getting stuck
    if ($httpCode >= 200 && $httpCode < 500) {
        logMessage("Notification received and processed");
        echo "OK";
    } else {
        // Only return FAIL for server errors (500+) which should trigger retry
        logMessage("Server error from Supabase: $httpCode");
        echo "OK"; // Still return OK to prevent indefinite retries
    }

} catch (Exception $e) {
    logMessage("EXCEPTION: " . $e->getMessage());
    // Return OK even on exception to prevent PayTR retry loops
    echo "OK";
}

logMessage("=== Callback Ended ===\n");
?>
