# 📦 SQL DOSYALARI REHBERİ

Bu klasörde 3 ana SQL dosyası bulunmaktadır.

## 🎯 Hangi Dosyayı Kullanmalıyım?

### 1. ⚡ MUSTERI-HIZLI-KURULUM.sql (ÖNERİLEN)
**MÜŞTERİYE TESLİMAT İÇİN EN İYİ DOSYA**

- ✅ Tek dosyada tüm kurulum
- ✅ Müşteri dostu açıklamalar
- ✅ 3 adımda kurulum tamamlanır
- ✅ 32 tablo + RLS + İndeksler
- ✅ Örnek veriler dahil

**Kullanım:**
```
1. Supabase Dashboard > SQL Editor
2. Dosyayı kopyala-yapıştır
3. "Run" butonuna tıkla
4. Bitti!
```

---

### 2. 📚 COMPLETE_DATABASE_SETUP.sql (DETAYLI)
**DETAYLI AÇIKLAMALI VERSİYON**

- ✅ Her adım açıklamalı
- ✅ Tablolar kategorilendirilmiş
- ✅ Tüm RLS politikaları detaylı
- ✅ Fonksiyonlar ve trigger'lar
- ✅ Geliştirici dostu

**Ne zaman kullanılır:**
- Sistemi öğrenmek isteyenler için
- Detaylı dokümantasyon gerektiğinde
- Özel modifikasyonlar için

---

### 3. 📁 KOLAY_KURULUM.sql
**ESKİ VERSİYON (Güncelleme Gerekebilir)**

- ⚠️ Bazı yeni özellikler eksik olabilir
- ⚠️ RLS politikaları eksik olabilir
- ⚠️ Kullanmadan önce kontrol edin

---

## 🗂️ Arşiv Klasörleri

### migrations_archive/
Eski migration dosyaları (14 adet) - Artık kullanılmıyor

### migrations_backup/
Çok eski backup'lar (70 adet) - Artık kullanılmıyor

---

## ⚠️ ÖNEMLİ NOTLAR

1. **İlk Kurulum:** `MUSTERI-HIZLI-KURULUM.sql` kullanın
2. **Güncelleme:** Mevcut verileri silmeden çalışır (IF NOT EXISTS)
3. **RLS:** Tüm tablolarda Row Level Security aktif
4. **Performans:** İndeksler otomatik oluşturulur

---

## 🆘 SORUN GİDERME

### "Table already exists" hatası
✅ Normal! Dosya zaten var olan tabloları atlamak üzere tasarlandı.

### RLS hatası
✅ Politikalar otomatik DROP IF EXISTS ile güncellenir.

### Foreign key hatası
❌ Tabloları doğru sırada oluşturduğunuzdan emin olun. MUSTERI-HIZLI-KURULUM.sql bunu otomatik halleder.

---

## 📞 DESTEK

- WhatsApp: +90 552 065 71 21
- Email: info@scriptsatisdunyasi.com.tr

---

## 📊 TABLO LİSTESİ (32 Adet)

### Ana Tablolar (6)
1. profiles - Kullanıcı profilleri
2. categories - Kategoriler
3. products - Ürünler
4. orders - Siparişler
5. order_items - Sipariş kalemleri
6. site_settings - Site ayarları

### Bayilik Sistemi (10)
7. dealer_packages - Bayilik paketleri
8. dealer_applications - Başvurular
9. dealers - Bayiler
10. dealer_customers - Bayi müşterileri
11. dealer_licenses - Bayi lisansları
12. dealer_sales - Bayi satışları
13. dealer_downloads - Bayi indirmeleri
14. dealer_support_tickets - Destek talepleri
15. dealer_api_usage - API kullanımı
16. license_activations - Lisans aktivasyonları

### İçerik (7)
17. blog_posts - Blog yazıları
18. product_reviews - Ürün yorumları
19. sliders - Ana sayfa slider'ları
20. banners - Bannerlar
21. services - Hizmetler
22. pages - Sayfalar
23. testimonials - Müşteri yorumları

### Entegrasyonlar (2)
24. integrations - Entegrasyonlar
25. web_designs - Web tasarımları

### Sistem (7)
26. licenses - Lisanslar
27. license_notes - Lisans notları
28. admin_users - Admin kullanıcıları
29. newsletter_subscriptions - Newsletter
30. cart_items - Sepet
31. wallet_transactions - Cüzdan işlemleri
32. product_views - Ürün görüntüleme analitikleri

---

✅ **Toplam: 32 Tablo + RLS + İndeksler + Fonksiyonlar**
