<?php
/**
 * File Upload Handler
 * Script Satış Dünyası - Dosya Yükleme Sistemi
 *
 * Bu dosya resim ve dosya yüklemelerini /uploads klasörüne kaydeder
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// OPTIONS request için
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Sadece POST kabul et
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Sadece POST metodu kabul edilir']);
    exit();
}

// Dosya kontrolü
if (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Dosya yüklenemedi']);
    exit();
}

$file = $_FILES['file'];
$folder = isset($_POST['folder']) ? $_POST['folder'] : 'general';

// Güvenlik: Folder name kontrolü
$folder = preg_replace('/[^a-zA-Z0-9_-]/', '', $folder);

// Dosya tipi kontrolü
$allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/svg+xml'];
$file_type = mime_content_type($file['tmp_name']);

if (!in_array($file_type, $allowed_types)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Sadece resim dosyaları yüklenebilir']);
    exit();
}

// Dosya boyutu kontrolü (10MB max)
if ($file['size'] > 10 * 1024 * 1024) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Dosya boyutu 10MB\'dan büyük olamaz']);
    exit();
}

// Upload klasörü oluştur
$upload_dir = __DIR__ . '/uploads/' . $folder;
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Dosya adını temizle
$original_name = basename($file['name']);
$file_extension = strtolower(pathinfo($original_name, PATHINFO_EXTENSION));
$clean_name = preg_replace('/[^a-zA-Z0-9_-]/', '_', pathinfo($original_name, PATHINFO_FILENAME));
$file_name = $clean_name . '.' . $file_extension;

// Benzersiz isim oluştur (aynı isim varsa)
$target_file = $upload_dir . '/' . $file_name;
$counter = 1;
while (file_exists($target_file)) {
    $file_name = $clean_name . '_' . $counter . '.' . $file_extension;
    $target_file = $upload_dir . '/' . $file_name;
    $counter++;
}

// Dosyayı kaydet
if (move_uploaded_file($file['tmp_name'], $target_file)) {
    $public_url = '/uploads/' . $folder . '/' . $file_name;

    echo json_encode([
        'success' => true,
        'message' => 'Dosya başarıyla yüklendi',
        'url' => $public_url,
        'filename' => $file_name
    ]);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Dosya kaydedilemedi']);
}
?>
